<?php
class Logger {
    private $db;
    private $actor_id;
    private $actor_type;
    private $actor_name;
    private $actor_device;
    private $ip_address;

    public function __construct($pdo, $sessionUser = null) {
        $this->db = $pdo;

        if ($sessionUser) {
            $this->actor_id = $sessionUser['id'];
            $this->actor_type = $sessionUser['type']; // user/admin/delivery
            $this->actor_name = $sessionUser['name'];
        } else {
            $this->actor_id = 0;
            $this->actor_type = 'system';
            $this->actor_name = 'System';
        }

        $this->actor_device = $_SERVER['HTTP_USER_AGENT'] ?? null;
        $this->ip_address = $_SERVER['REMOTE_ADDR'] ?? null;
    }

    public function log($user_id, $user_type, $action_type, $reference_id, $reference_table, $description, $old_values = null, $new_values = null, $status_before = null, $status_after = null) {
        $sql = "INSERT INTO logs
            (user_id, user_type, action_type, reference_id, reference_table, description, old_values, new_values, actor_id, actor_type, actor_name, actor_device, ip_address, status_before, status_after, created_at)
            VALUES
            (:user_id, :user_type, :action_type, :reference_id, :reference_table, :description, :old_values, :new_values, :actor_id, :actor_type, :actor_name, :actor_device, :ip_address, :status_before, :status_after, NOW())";

        $stmt = $this->db->prepare($sql);
        $stmt->execute([
            ':user_id' => $user_id,
            ':user_type' => $user_type,
            ':action_type' => $action_type,
            ':reference_id' => $reference_id,
            ':reference_table' => $reference_table,
            ':description' => $description,
            ':old_values' => $old_values ? json_encode($old_values, JSON_UNESCAPED_UNICODE) : null,
            ':new_values' => $new_values ? json_encode($new_values, JSON_UNESCAPED_UNICODE) : null,
            ':actor_id' => $this->actor_id,
            ':actor_type' => $this->actor_type,
            ':actor_name' => $this->actor_name,
            ':actor_device' => $this->actor_device,
            ':ip_address' => $this->ip_address,
            ':status_before' => $status_before,
            ':status_after' => $status_after
        ]);
    }
}
