<?php
include "../connect.php";

$usersid = filterRequest("usersid");

function getUserPhone($usersid) {
    global $con;
    
    // Prepare and execute the query
    $stmt = $con->prepare("SELECT users_phone FROM users WHERE users_id = :usersid");
    $stmt->bindParam(':usersid', $usersid, PDO::PARAM_INT);
    $stmt->execute();
    
    // Fetch the result
    $data = $stmt->fetch(PDO::FETCH_ASSOC);
    
    // Return the phone number or an empty string if not found
    return $data ? $data['users_phone'] : '';
}

// Assuming you need to output a JSON response
header('Content-Type: application/json');
$response = array(
    'status' => 'success',
    'phone' => getUserPhone($usersid)
);
echo json_encode($response);
?>
