<?php
header("Content-Type: application/json");
include __DIR__ . "/../../connect.php"; 

$sessionToken = $_POST['session_token'] ?? '';

if (empty($sessionToken)) {
    echo json_encode(["valid" => false]);
    exit;
}

try {
    $stmt = $con->prepare("
        SELECT a.admin_id 
        FROM admin_sessions s
        JOIN admin a ON s.admin_id = a.admin_id
        WHERE s.session_token = :token
        LIMIT 1
    ");
    $stmt->execute([":token" => $sessionToken]);

    if ($stmt->rowCount() > 0) {
        echo json_encode(["valid" => true]);
    } else {
        // Either token missing OR admin deleted
        echo json_encode(["valid" => false]);
    }
} catch (PDOException $e) {
    echo json_encode([
        "valid" => false,
        "error" => $e->getMessage()
    ]);
}
