<?php
include "../../connect.php";

// Get input
$email = filterRequest("email");
$password = sha1($_POST['password']); // matches stored password

// Prepare statement to prevent SQL injection
$stmt = $con->prepare("SELECT * FROM admin WHERE admin_email = ? AND admin_password = ?");
$stmt->execute([$email, $password]);

// Fetch the user
$data = $stmt->fetch(PDO::FETCH_ASSOC);

if ($data) {
    // Successful login
    $adminId = $data['admin_id'];
    
    // Generate a unique session token
    $token = bin2hex(random_bytes(32));

    // Save token in the admin_sessions table
    $stmt2 = $con->prepare("INSERT INTO admin_sessions (admin_id, session_token) VALUES (:admin_id, :token)");
    $stmt2->execute([
        ':admin_id' => $adminId,
        ':token' => $token
    ]);

    // Return success response including the token
    echo json_encode([
        "status" => "success",
        "data"   => $data,
        "token"  => $token
    ]);
} else {
    // Failed login
    echo json_encode([
        "status" => "failure",
        "message" => "Email or password is incorrect"
    ]);
}
?>
