<?php  
header("Content-Type: application/json; charset=utf-8");
include "../../connect.php";

$table = "admin";

// Read JSON input
$data = json_decode(file_get_contents("php://input"), true);
if (json_last_error() !== JSON_ERROR_NONE) {
    echo json_encode(["status" => "failure", "message" => "Invalid JSON"]);
    exit;
}

$username = $data['username'] ?? '';
$password = isset($data['password']) ? sha1($data['password']) : '';
$email    = $data['email'] ?? '';
$phone    = $data['phone'] ?? '';
$birthday = $data['birthday'] ?? '';
$role     = $data['role'] ?? 1;
$verifycode = rand(10000, 99999);

// Validate required fields
if (empty($username) || empty($password) || empty($email) || empty($phone) || empty($birthday)) {
    echo json_encode(["status" => "failure", "message" => "All fields are required", "verified" => false]);
    exit;
}

// Validate email format
if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
    echo json_encode(["status" => "failure", "message" => "Invalid email format", "verified" => false]);
    exit;
}

// Check if email or phone exists
$stmt = $con->prepare("SELECT * FROM $table WHERE admin_email=? OR admin_phone=?");
$stmt->execute([$email, $phone]);
if ($stmt->rowCount() > 0) {
    echo json_encode(["status" => "failure", "message" => "Email or Phone already exists", "verified" => false]);
    exit;
}

// Insert data
$dataToInsert = [
    "admin_name"       => $username,
    "admin_password"   => $password,
    "admin_email"      => $email,
    "admin_phone"      => $phone,
    "admin_birthday"   => $birthday,
    "admin_verifycode" => $verifycode,
    "admin_role"       => $role,
    "admin_approve"    => 0,
    "admin_create"     => date("Y-m-d H:i:s")
];

$columns = implode(", ", array_keys($dataToInsert));
$placeholders = implode(", ", array_fill(0, count($dataToInsert), "?"));
$stmt = $con->prepare("INSERT INTO $table ($columns) VALUES ($placeholders)");

if ($stmt->execute(array_values($dataToInsert))) {
    // Send email with better headers
    $emailSent = sendVerificationEmail($email, $verifycode);
    
    echo json_encode([
        "status" => "success",
        "message" => "Admin created successfully. " . ($emailSent ? "Verification code sent." : "But failed to send email."),
        "verified" => false,
        "email_sent" => $emailSent
    ]);
} else {
    echo json_encode(["status" => "failure", "message" => "Could not create admin", "verified" => false]);
}

// Improved email function
function sendVerificationEmail($to, $verifycode) {
    $subject = "Admin Verify Code";
    $message = "Your Admin Verify Code: $verifycode\n\n";
    $message .= "This code will expire after 24 hours.\n";
    
    $headers = "From: admin@natashabeauty.de" . "\r\n" .
               "Reply-To: admin@natashabeauty.de" . "\r\n" .
               "X-Mailer: PHP/" . phpversion() . "\r\n" .
               "MIME-Version: 1.0" . "\r\n" .
               "Content-Type: text/plain; charset=UTF-8";
    
    try {
        return mail($to, $subject, $message, $headers);
    } catch (Exception $e) {
        error_log("Email error: " . $e->getMessage());
        return false;
    }
}
?>