<?php
include "../../connect.php";

$table = "items";
$no = filterRequest("no");
if ($no === null || $no === "") {
    die(json_encode(array('error' => 'Invalid or missing item number')));
}
$name = filterRequest("name");
$namear = filterRequest("namear");
$desc = filterRequest("desc");
$descar = filterRequest("descar");
$count = filterRequest("count");
$price = filterRequest("price");
$discount = filterRequest("discount");
$catid = filterRequest("catid");
$imagename = imageUpload("../../upload/items", "files");
$datenow = filterRequest("datenow");

$data = array(
    "items_no" => $no,
    "items_name" => $name,
    "items_name_ar" => $namear,
    "items_desc" => $desc,
    "items_desc_ar" => $descar,
    "items_count" => $count,
    "items_active" => "1",
    "items_price" => $price,
    "items_discount" => $discount,
    "items_cat" => $catid,
    "items_image" => $imagename,
    "items_date" => $datenow,
);

$result = insertData($table, $data,$json=false);

$response = array();

if ($result) {
    $lastInsertedId = getLastInsertedItemId($table, false);
    $response['item_id'] = $lastInsertedId;
} else {
    $response['item_id'] = null; // Or you can omit this line if you don't want to provide item_id in case of failure
}

header('Content-Type: application/json'); // Set content type to JSON
echo json_encode($response);

function getLastInsertedItemId($table, $json = true)
{
    global $con;
    $stmt = $con->prepare("SELECT items_id FROM $table ORDER BY items_id DESC LIMIT 1");
    $stmt->execute();
    $data = $stmt->fetch(PDO::FETCH_ASSOC);
    return $data['items_id'];
}
?>
