<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
header('Content-Type: application/json; charset=utf-8');

// Include your PDO connection
include "../../connect.php";

// Use the correct PDO variable
$conn = $con ?? null;

if (!$conn) {
    echo json_encode(['status' => 'failure']);
    exit;
}

// Get POST data safely
$id        = $_POST['id'] ?? null;
$no        = $_POST['no'] ?? '';
$name      = $_POST['name'] ?? '';
$namear    = $_POST['namear'] ?? '';
$desc      = $_POST['desc'] ?? '';
$descar    = $_POST['descar'] ?? '';
$count     = $_POST['count'] ?? 0;
$active    = $_POST['active'] ?? 0;
$discount  = $_POST['discount'] ?? 0;
$catid     = $_POST['catid'] ?? '';
$imageold  = $_POST['imageold'] ?? '';
$datenow   = $_POST['datenow'] ?? date('Y-m-d H:i:s');
$quantities = $_POST['quantities'] ?? '[]';
$prices     = $_POST['prices'] ?? '[]';

// Decode JSON arrays safely
$quantitiesArr = json_decode($quantities, true);
$pricesArr     = json_decode($prices, true);

if (!$id) {
    echo json_encode(['status' => 'failure']);
    exit;
}

// Handle file upload
$imageFile = $imageold;
if (isset($_FILES['file']) && $_FILES['file']['error'] == 0) {
    $targetDir = "../../uploads/items/";
    if (!file_exists($targetDir)) mkdir($targetDir, 0777, true);

    $fileName = time() . "_" . basename($_FILES['file']['name']);
    $targetFile = $targetDir . $fileName;

    if (move_uploaded_file($_FILES['file']['tmp_name'], $targetFile)) {
        $imageFile = $fileName;
    }
}

// Update DB
try {
    $conn->beginTransaction();

    // Update main item
    $stmt = $conn->prepare("UPDATE items SET 
        items_no=?, items_name=?, items_name_ar=?, items_desc=?, items_desc_ar=?, 
        items_count=?, items_active=?, items_discount=?, items_cat=?, items_image=?, items_date=?
        WHERE items_id=?");
    $stmt->execute([
        $no, $name, $namear, $desc, $descar,
        $count, $active, $discount, $catid, $imageFile, $datenow,
        $id
    ]);

    // Update item_prices table
    // First, delete old prices for this item
    $conn->prepare("DELETE FROM item_prices WHERE item_id=?")->execute([$id]);

    // Insert new quantities/prices
    if (is_array($quantitiesArr) && is_array($pricesArr)) {
        $insertStmt = $conn->prepare("INSERT INTO item_prices (item_id, quantity, price) VALUES (?, ?, ?)");
        foreach ($quantitiesArr as $k => $q) {
            $p = $pricesArr[$k] ?? 0;
            $insertStmt->execute([$id, $q, $p]);
        }
    }

    $conn->commit();
    echo json_encode(['status' => 'success']);

} catch (Exception $e) {
    $conn->rollBack();
    echo json_encode(['status' => 'failure']);
}
