<?php
header('Content-Type: application/json');
include "../../connect.php"; // PDO connection

$adminId = $_POST['adminId'] ?? '';
$oldPassword = $_POST['oldPassword'] ?? '';
$newPassword = $_POST['newPassword'] ?? '';

if (empty($adminId) || empty($oldPassword) || empty($newPassword)) {
    echo json_encode([
        "status" => "failure",
        "message" => "All fields are required"
    ]);
    exit;
}

// Check old password
$stmt = $con->prepare("SELECT admin_password FROM admin WHERE admin_id = :adminId LIMIT 1");
$stmt->bindValue(':adminId', $adminId, PDO::PARAM_INT);
$stmt->execute();
$row = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$row) {
    echo json_encode([
        "status" => "failure",
        "message" => "Admin not found"
    ]);
    exit;
}

if ($row['admin_password'] !== sha1($oldPassword)) {
    echo json_encode([
        "status" => "failure",
        "message" => "Old password is incorrect"
    ]);
    exit;
}

// Update password
$newHashedPassword = sha1($newPassword);
$stmt = $con->prepare("UPDATE admin SET admin_password = :newPassword WHERE admin_id = :adminId");
$stmt->bindValue(':newPassword', $newHashedPassword, PDO::PARAM_STR);
$stmt->bindValue(':adminId', $adminId, PDO::PARAM_INT);

if ($stmt->execute()) {
    echo json_encode([
        "status" => "success",
        "message" => "Password changed successfully"
    ]);
} else {
    echo json_encode([
        "status" => "failure",
        "message" => "Failed to change password"
    ]);
}
?>
