<?php
header('Content-Type: application/json');
include "../../connect.php"; // your PDO database connection

$adminId = $_POST['adminId'] ?? '';

if (empty($adminId)) {
    echo json_encode([
        "status" => "failure",
        "message" => "Admin ID is required"
    ]);
    exit;
}

// Prepare statement
$stmt = $con->prepare("SELECT admin_id, admin_name, admin_email, admin_phone, admin_birthday FROM admin WHERE admin_id = :adminId LIMIT 1");

// Bind parameter using PDO
$stmt->bindValue(':adminId', $adminId, PDO::PARAM_INT);

// Execute
$stmt->execute();

// Fetch result
$data = $stmt->fetch(PDO::FETCH_ASSOC);

if ($data) {
    echo json_encode([
        "status" => "success",
        "data" => $data
    ]);
} else {
    echo json_encode([
        "status" => "failure",
        "message" => "Admin not found"
    ]);
}
?>
