<?php
header('Content-Type: application/json');
include "../../connect.php"; // PDO connection

$adminId = $_POST['adminId'] ?? '';
$name = $_POST['name'] ?? '';
$phone = $_POST['phone'] ?? '';
$birthday = $_POST['birthday'] ?? '';

if (empty($adminId) || empty($name) || empty($phone) || empty($birthday)) {
    echo json_encode([
        "status" => "failure",
        "message" => "جميع الحقول مطلوبة"
    ]);
    exit;
}

try {
    $stmt = $con->prepare("
        UPDATE admin 
        SET admin_name = :name, admin_phone = :phone, admin_birthday = :birthday 
        WHERE admin_id = :adminId
    ");
    $stmt->bindValue(':name', $name, PDO::PARAM_STR);
    $stmt->bindValue(':phone', $phone, PDO::PARAM_STR);
    $stmt->bindValue(':birthday', $birthday, PDO::PARAM_STR);
    $stmt->bindValue(':adminId', $adminId, PDO::PARAM_INT);

    if ($stmt->execute()) {
        echo json_encode([
            "status" => "success",
            "message" => "تم تحديث الملف الشخصي بنجاح"
        ]);
    } else {
        echo json_encode([
            "status" => "failure",
            "message" => "فشل في تحديث الملف الشخصي"
        ]);
    }
} catch (PDOException $e) {
    echo json_encode([
        "status" => "failure",
        "message" => "حدث خطأ: " . $e->getMessage()
    ]);
}
?>
