<?php
// Enable full error reporting
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Debug log file
$debug_file = __DIR__ . '/prepare_debug.log';
error_log("----- Prepare Script Started -----\n", 3, $debug_file);
error_log(date('Y-m-d H:i:s') . " - POST received: " . json_encode($_POST) . "\n", 3, $debug_file);

include "../../connect.php";

// Get POST parameters
$orderid = filterRequest("ordersid");
$userid = filterRequest("usersid");
$type    = filterRequest("ordertype");

// Validate required parameters
if (!$orderid || !$userid || $type === null) {
    error_log(date('Y-m-d H:i:s') . " - Missing required parameters\n", 3, $debug_file);
    echo json_encode(["status"=>"failure", "message"=>"Missing required parameters"]);
    exit;
}

// Set order status depending on type
// Delivery (0) → status 2 (preparing/on the way)
// Receive (1) → status 3 (preparing/ready for pickup)
if ($type == "0") {
    $data = ["orders_status" => 2]; // Delivery preparing
} else {
    $data = ["orders_status" => 3]; // Receive preparing
}

// Update order status
$updated = updateData("orders", $data, "orders_id=$orderid AND orders_status=1", false);
error_log(date('Y-m-d H:i:s') . " - Order update rows: $updated\n", 3, $debug_file);

// Insert user notification
$notified = insertNotify(
    "Dear User",
    "The Order is being prepared",
    "جاري تحضير الطلب",
    "عزيزي المستخدم",
    $userid,
    "users$userid",
    "none",
    "refreshorderpending",
    'en' // or $language if you want later
);
error_log(date('Y-m-d H:i:s') . " - Notification rows: $notified\n", 3, $debug_file);

// Optionally notify delivery/admin if delivery type
if ($type == "0") {
    try {
        sendGCM(
            "Notice",
            "There is an order waiting for approval",
            "ملاحظة",
            "هناك طلب بانتظار الموافقة",
            "delivery",
            "",
            "",
            'en'
        );
        error_log(date('Y-m-d H:i:s') . " - Delivery/Admin notification sent\n", 3, $debug_file);
    } catch (Exception $e) {
        error_log(date('Y-m-d H:i:s') . " - sendGCM failed: ".$e->getMessage()."\n", 3, $debug_file);
        // Do not exit — prevent 404
    }
}

// Return JSON result
$status  = $updated > 0 ? "success" : "failure";
$message = $updated > 0 ? "Order status updated successfully" : "Order was not updated";

$response = [
    "status" => $status,
    "message" => $message,
    "orderId" => $orderid,
    "userId"  => $userid,
    "type"    => $type,
    "updated" => $updated,
    "notified"=> $notified
];

echo json_encode($response);
error_log("----- Prepare Script Finished -----\n", 3, $debug_file);
?>
