<?php
include "../../connect.php";
$table = "item_prices";

// Fetch itemId safely
$itemId = filterRequest("item_id");

if (!$itemId) {
    die("Error: item_id is missing or invalid.");
}

$quantities = isset($_POST['quantities']) ? json_decode($_POST['quantities'], true) : [];
$prices = isset($_POST['prices']) ? json_decode($_POST['prices'], true) : [];

// Check if JSON decoding was successful
if (json_last_error() !== JSON_ERROR_NONE) {
    die("Error: Failed to decode JSON data.");
}

// Validate that quantities and prices arrays are of the same length
if (count($quantities) !== count($prices)) {
    die("Error: Quantities and prices arrays must be of the same length.");
}

try {
    $stmt = $con->prepare("INSERT INTO item_prices (item_id, quantity, price) VALUES (?, ?, ?)");
    
    for ($i = 0; $i < count($quantities); $i++) {
        $stmt->execute([$itemId, $quantities[$i], $prices[$i]]);
    }

    $count = $stmt->rowCount();

    if ($count > 0) {
        echo json_encode(array("status" => "success"));
    } else {
        echo json_encode(array("status" => "failure"));
    }
} catch (PDOException $e) {
    die("Database error: " . $e->getMessage());
}
?>
