<?php
header("Content-Type: application/json");
include "../../connect.php"; // Adjust path if needed

try {
    // Query to count orders by status and sum revenue for done orders
    $stmt = $con->query("
        SELECT 
            SUM(CASE WHEN orders_status = 0 THEN 1 ELSE 0 END) AS pending,
            SUM(CASE WHEN orders_status = 1 THEN 1 ELSE 0 END) AS accepted,
            SUM(CASE WHEN orders_status = 2 THEN 1 ELSE 0 END) AS delivered,
            SUM(CASE WHEN orders_status = 3 THEN 1 ELSE 0 END) AS done,
            SUM(CASE WHEN orders_status = 4 THEN 1 ELSE 0 END) AS archived,
            COUNT(*) AS totalOrders,
            SUM(CASE WHEN orders_status = 3 THEN orders_totalprice ELSE 0 END) AS revenue
        FROM orders
    ");

    $report = $stmt->fetch(PDO::FETCH_ASSOC);

    echo json_encode([
        "success" => true,
        "report" => $report
    ]);

} catch (PDOException $e) {
    echo json_encode([
        "success" => false,
        "message" => "Database error: " . $e->getMessage()
    ]);
}
