<?php
header("Content-Type: application/json");
include __DIR__ . "/../../connect.php";

try {
    // Total users
    $stmt = $con->query("SELECT COUNT(*) as total FROM users");
    $total = $stmt->fetch(PDO::FETCH_ASSOC)['total'];

    // Active users
    $stmt = $con->query("SELECT COUNT(*) as active FROM users WHERE users_approve = 1");
    $active = $stmt->fetch(PDO::FETCH_ASSOC)['active'];

    // Pending users
    $stmt = $con->query("SELECT COUNT(*) as pending FROM users WHERE users_approve = 0");
    $pending = $stmt->fetch(PDO::FETCH_ASSOC)['pending'];

    // Verified users (users_verifycode = 1)
    $stmt = $con->query("SELECT COUNT(*) as verified FROM users WHERE users_approve = 1");
    $verified = $stmt->fetch(PDO::FETCH_ASSOC)['verified'];

    // New users in last 7 days
    $stmt = $con->query("SELECT COUNT(*) as new_users FROM users WHERE users_create >= DATE_SUB(NOW(), INTERVAL 7 DAY)");
    $newUsers = $stmt->fetch(PDO::FETCH_ASSOC)['new_users'];

    echo json_encode([
        "success" => true,
        "data" => [
            "total_users"    => $total,
            "active_users"   => $active,
            "pending_users"  => $pending,
            "verified_users" => $verified,
            "new_users"      => $newUsers
        ]
    ]);
} catch (PDOException $e) {
    echo json_encode([
        "success" => false,
        "message" => $e->getMessage()
    ]);
}
?>
