<?php
include "../connect.php";

$fcm_token = $_POST['fcm_token'] ?? null;
$user_id   = $_POST['usersid'] ?? null;

if (!$fcm_token || !$user_id) {
    echo json_encode(["status" => "error", "message" => "Token or usersid missing"]);
    exit;
}

// Create table if it doesn't exist
$con->exec("CREATE TABLE IF NOT EXISTS user_tokens (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT NOT NULL,
    fcm_token VARCHAR(255) NOT NULL,
    created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
    UNIQUE(user_id, fcm_token)
)");

// Insert or update token
$stmt = $con->prepare("
    INSERT INTO user_tokens (user_id, fcm_token) VALUES (?, ?)
    ON DUPLICATE KEY UPDATE created_at = CURRENT_TIMESTAMP
");

try {
    $stmt->execute([$user_id, $fcm_token]);
    echo json_encode(["status" => "success", "message" => "Token saved"]);
} catch (PDOException $e) {
    echo json_encode(["status" => "error", "message" => $e->getMessage()]);
}
?>
