<?php
header("Content-Type: application/json");
include __DIR__ . "/../../connect.php";

$adminId = isset($_POST['admin_id']) ? intval($_POST['admin_id']) : 0;

if ($adminId <= 0) {
    echo json_encode(["success" => false, "message" => "Invalid admin ID"]);
    exit;
}

try {
    // Delete admin from admin table
    $stmt = $con->prepare("DELETE FROM admin WHERE admin_id = :id");
    $stmt->execute([":id" => $adminId]);

    // Delete all session tokens for this admin
    $stmt2 = $con->prepare("DELETE FROM admin_sessions WHERE admin_id = :id");
    $stmt2->execute([":id" => $adminId]);

    echo json_encode([
        "success" => true,
        "message" => "Admin deleted and session ended successfully"
    ]);

} catch (PDOException $e) {
    echo json_encode([
        "success" => false,
        "message" => "Database error: " . $e->getMessage()
    ]);
}
?>
