<?php
header("Content-Type: application/json");

// Include database connection
include __DIR__ . "/../../connect.php"; // adjust path if needed

if (!isset($con)) {
    echo json_encode([
        "success" => false,
        "message" => "Database connection not found"
    ]);
    exit;
}

// Get POST data
$deliveryId = isset($_POST['user_id']) ? intval($_POST['user_id']) : 0;

if ($deliveryId <= 0) {
    echo json_encode([
        "success" => false,
        "message" => "Invalid delivery user ID"
    ]);
    exit;
}

try {
    // ✅ Use delivery_id (real column name in your table)
    $stmt = $con->prepare("DELETE FROM delivery WHERE delivery_id = ?");
    $stmt->execute([$deliveryId]);

    echo json_encode([
        "success" => true,
        "message" => "Delivery user deleted successfully"
    ]);
} catch (PDOException $e) {
    echo json_encode([
        "success" => false,
        "message" => "Database error: " . $e->getMessage()
    ]);
}
?>
