<?php
header("Content-Type: application/json");
include __DIR__ . "/../../connect.php";

if (!isset($con)) {
    echo json_encode(["success" => false, "message" => "Database connection not found"]);
    exit;
}

$userId = isset($_POST['user_id']) ? intval($_POST['user_id']) : 0;

if ($userId <= 0) {
    echo json_encode(["success" => false, "message" => "Invalid user ID"]);
    exit;
}

try {
    $stmt = $con->prepare("DELETE FROM users WHERE users_id = :id");
    $stmt->execute([":id" => $userId]);

    echo json_encode([
        "success" => true,
        "message" => "User deleted successfully"
    ]);
} catch (PDOException $e) {
    echo json_encode(["success" => false, "message" => "Database error: " . $e->getMessage()]);
}
?>
