<?php
header("Content-Type: application/json");
include __DIR__ . "/../../connect.php";

$adminId = isset($_POST['admin_id']) ? intval($_POST['admin_id']) : 0;
$name = isset($_POST['name']) ? trim($_POST['name']) : '';
$email = isset($_POST['email']) ? trim($_POST['email']) : '';
$phone = isset($_POST['phone']) ? trim($_POST['phone']) : '';

if ($adminId <= 0) {
    echo json_encode([
        "success" => false,
        "message" => "Invalid admin ID"
    ]);
    exit;
}

try {
    $stmt = $con->prepare("
        UPDATE admins
        SET admin_name = ?, admin_email = ?, admin_phone = ?
        WHERE admin_id = ?
    ");
    $stmt->execute([$name, $email, $phone, $adminId]);

    echo json_encode([
        "success" => true,
        "message" => "Admin updated successfully"
    ]);
} catch (PDOException $e) {
    echo json_encode([
        "success" => false,
        "message" => "Database error: " . $e->getMessage()
    ]);
}
?>
