<?php
header("Content-Type: application/json");
include __DIR__ . "/../../connect.php";

$deliveryId = isset($_POST['delivery_id']) ? intval($_POST['delivery_id']) : 0;
$name = isset($_POST['name']) ? trim($_POST['name']) : '';
$email = isset($_POST['email']) ? trim($_POST['email']) : '';
$phone = isset($_POST['phone']) ? trim($_POST['phone']) : '';

if ($deliveryId <= 0) {
    echo json_encode([
        "success" => false,
        "message" => "Invalid delivery user ID"
    ]);
    exit;
}

try {
    $stmt = $con->prepare("
        UPDATE delivery
        SET delivery_name = ?, delivery_email = ?, delivery_phone = ?
        WHERE delivery_id = ?
    ");
    $stmt->execute([$name, $email, $phone, $deliveryId]);

    echo json_encode([
        "success" => true,
        "message" => "Delivery user updated successfully"
    ]);
} catch (PDOException $e) {
    echo json_encode([
        "success" => false,
        "message" => "Database error: " . $e->getMessage()
    ]);
}
?>
