<?php
header("Content-Type: application/json");
include __DIR__ . "/../../connect.php";

if (!isset($con)) {
    echo json_encode(["success" => false, "message" => "Database connection not found"]);
    exit;
}

// Get POST parameters
$userId = isset($_POST['user_id']) ? intval($_POST['user_id']) : 0;
$name = isset($_POST['name']) ? trim($_POST['name']) : '';
$email = isset($_POST['email']) ? trim($_POST['email']) : '';

if ($userId <= 0 || empty($name) || empty($email)) {
    echo json_encode(["success" => false, "message" => "Invalid input"]);
    exit;
}

try {
    $stmt = $con->prepare("UPDATE users SET users_name = :name, users_email = :email WHERE users_id = :id");
    $stmt->execute([
        ":name" => $name,
        ":email" => $email,
        ":id" => $userId
    ]);

    echo json_encode([
        "success" => true,
        "message" => "User updated successfully"
    ]);
} catch (PDOException $e) {
    echo json_encode(["success" => false, "message" => "Database error: " . $e->getMessage()]);
}
?>
