<?php
header("Content-Type: application/json");
include __DIR__ . "/../../connect.php";

try {
    $stmt = $con->prepare("
        SELECT 
            COALESCE(admin_id, 0) AS id,
            COALESCE(admin_name, '') AS name,
            COALESCE(admin_email, '') AS email,
            COALESCE(admin_phone, '') AS phone,
            COALESCE(admin_approve, 0) AS approved
        FROM admin
    ");
    $stmt->execute();
    $admins = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode([
        "success" => true,
        "data" => $admins ?: [] // always return an array
    ]);
} catch (PDOException $e) {
    echo json_encode([
        "success" => false,
        "message" => "Database error: " . $e->getMessage(),
        "data" => [] // prevent null
    ]);
}
?>
