<?php
header("Content-Type: application/json");
include __DIR__ . "/../../connect.php";

try {
    $stmt = $con->prepare("
        SELECT 
            COALESCE(delivery_id, 0) AS id,
            COALESCE(delivery_name, '') AS name,
            COALESCE(delivery_email, '') AS email,
            COALESCE(delivery_phone, '') AS phone,
            COALESCE(delivery_approve, 0) AS approved
        FROM delivery
    ");
    $stmt->execute();
    $deliveryUsers = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode([
        "success" => true,
        "data" => $deliveryUsers ?: [] // always return an array
    ]);
} catch (PDOException $e) {
    echo json_encode([
        "success" => false,
        "message" => "Database error: " . $e->getMessage(),
        "data" => [] // prevent null
    ]);
}
?>
