<?php
header("Content-Type: application/json");

// Include database connection using correct path
include __DIR__ . "/../../connect.php"; // adjust if needed

// Check if $con exists
if (!isset($con)) {
    echo json_encode([
        "success" => false,
        "message" => "Database connection not found"
    ]);
    exit;
}

try {
    // Prepare and execute the query
    $stmt = $con->prepare("SELECT users_id, users_name, users_email, users_phone, users_approve 
                           FROM users ORDER BY users_id DESC");
    $stmt->execute();

    // Fetch all rows
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    $users = [];
    foreach ($rows as $row) {
        $users[] = [
            "id" => intval($row['users_id']),
            "name" => $row['users_name'],
            "email" => $row['users_email'],
            "phone" => $row['users_phone'],
            "approved" => intval($row['users_approve']) === 1
        ];
    }

    // Return JSON response
    echo json_encode([
        "success" => true,
        "data" => $users
    ]);

} catch (PDOException $e) {
    echo json_encode([
        "success" => false,
        "message" => "Database error: " . $e->getMessage()
    ]);
}
?>
