<?php
header("Content-Type: application/json");

// Include database connection
include __DIR__ . "/../../connect.php"; // adjust path if needed

if (!isset($con)) {
    echo json_encode([
        "success" => false,
        "message" => "Database connection not found"
    ]);
    exit;
}

// Get POST data
$adminId = isset($_POST['admin_id']) ? intval($_POST['admin_id']) : 0;
$approved = isset($_POST['approved']) ? intval($_POST['approved']) : 0;

if ($adminId <= 0) {
    echo json_encode([
        "success" => false,
        "message" => "Invalid admin ID"
    ]);
    exit;
}

try {
    $stmt = $con->prepare("UPDATE admin SET admin_approve = ? WHERE admin_id = ?");
    $stmt->execute([$approved, $adminId]);

    echo json_encode([
        "success" => true,
        "message" => "Admin approval status updated",
        "approved" => $approved
    ]);
} catch (PDOException $e) {
    echo json_encode([
        "success" => false,
        "message" => "Database error: " . $e->getMessage()
    ]);
}
?>
