<?php
header("Content-Type: application/json");
include __DIR__ . "/../../connect.php";

if (!isset($con)) {
    echo json_encode(["success" => false, "message" => "Database connection not found"]);
    exit;
}

// Get POST parameters
$userId = isset($_POST['user_id']) ? intval($_POST['user_id']) : 0;
$approved = isset($_POST['approved']) ? intval($_POST['approved']) : 0;

if ($userId <= 0) {
    echo json_encode(["success" => false, "message" => "Invalid user ID"]);
    exit;
}

try {
    $stmt = $con->prepare("UPDATE users SET users_approve = :approved WHERE users_id = :id");
    $stmt->execute([
        ":approved" => $approved,
        ":id" => $userId
    ]);

    echo json_encode([
        "success" => true,
        "message" => "User approval status updated"
    ]);
} catch (PDOException $e) {
    echo json_encode(["success" => false, "message" => "Database error: " . $e->getMessage()]);
}
?>
