<?php
header("Content-Type: application/json");

// Include database connection
include __DIR__ . "/../../connect.php"; // adjust path if needed

if (!isset($con)) {
    echo json_encode([
        "success" => false,
        "message" => "Database connection not found"
    ]);
    exit;
}

// Get POST data
$deliveryId = isset($_POST['delivery_id']) ? intval($_POST['delivery_id']) : 0;
$approved   = isset($_POST['approved']) ? intval($_POST['approved']) : 0;

if ($deliveryId <= 0) {
    echo json_encode([
        "success" => false,
        "message" => "Invalid delivery user ID"
    ]);
    exit;
}

try {
    // Use correct column names: delivery_approve and delivery_id
    $stmt = $con->prepare("UPDATE delivery SET delivery_approve = ? WHERE delivery_id = ?");
    $stmt->execute([$approved, $deliveryId]);

    echo json_encode([
        "success" => true,
        "message" => "Delivery user approval status updated",
        "approved" => $approved
    ]);
} catch (PDOException $e) {
    echo json_encode([
        "success" => false,
        "message" => "Database error: " . $e->getMessage()
    ]);
}
?>
