<?php
header("Content-Type: application/json");
include __DIR__ . "/../../connect.php";

// Get POST data
$adminId = isset($_POST['user_id']) ? intval($_POST['user_id']) : 0;
$newPassword = isset($_POST['password']) ? trim($_POST['password']) : '';

if ($adminId <= 0 || $newPassword === '') {
    echo json_encode([
        "success" => false,
        "message" => "Invalid input data"
    ]);
    exit;
}

try {
    // Hash the password securely
    $hashedPassword = password_hash($newPassword, PASSWORD_DEFAULT);

    $stmt = $con->prepare("UPDATE admin SET admin_password = ? WHERE admin_id = ?");
    $stmt->execute([$hashedPassword, $adminId]);

    echo json_encode([
        "success" => true,
        "message" => "Admin password updated successfully"
    ]);
} catch (PDOException $e) {
    echo json_encode([
        "success" => false,
        "message" => "Database error: " . $e->getMessage()
    ]);
}
?>
