<?php
header("Content-Type: application/json");
include __DIR__ . "/../../connect.php";

// Get POST data
$deliveryId = isset($_POST['user_id']) ? intval($_POST['user_id']) : 0;
$newPassword = isset($_POST['password']) ? trim($_POST['password']) : '';

if ($deliveryId <= 0 || $newPassword === '') {
    echo json_encode([
        "success" => false,
        "message" => "Invalid input data"
    ]);
    exit;
}

try {
    // Hash the password securely
    $hashedPassword = password_hash($newPassword, PASSWORD_DEFAULT);

    $stmt = $con->prepare("UPDATE delivery SET delivery_password = ? WHERE delivery_id = ?");
    $stmt->execute([$hashedPassword, $deliveryId]);

    echo json_encode([
        "success" => true,
        "message" => "Delivery user password updated successfully"
    ]);
} catch (PDOException $e) {
    echo json_encode([
        "success" => false,
        "message" => "Database error: " . $e->getMessage()
    ]);
}
?>
