<?php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include_once "../connect.php";
include_once "../functions.php"; // Ensure this is included only once

$usersid = filterRequest("usersid");

// Validate usersid as an integer
if (!is_numeric($usersid)) {
    echo json_encode(array("status" => "error", "message" => "Invalid user ID"));
    exit();
}

try {
    $stmt = $con->prepare("
        SELECT COUNT(*) as totalcount 
        FROM cartview 
        WHERE cartview.cart_usersid = :usersid AND cartview.items_active = 1
    ");
    $stmt->bindParam(':usersid', $usersid, PDO::PARAM_INT);
    $stmt->execute();
    
    $datacount = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($datacount !== false) {
        echo json_encode(array("status" => "success", "totalcount" => $datacount['totalcount']));
    } else {
        echo json_encode(array("status" => "error", "message" => "No data found"));
    }
} catch (PDOException $e) {
    echo json_encode(array("status" => "error", "message" => "Database error", "error" => $e->getMessage()));
}
?>
