<?php
include "connect.php";

$table_categories = "categories";
$table_settings = "settings";
$table_most_selling = "itemstopselling"; // contains items_id and countitems
$table_items = "item3sview"; // full item details

$alldata = array();
$alldata['status'] = 'success';

// 1️⃣ Fetch settings
$settings = getAllData($table_settings, "1 = 1", null, false);
$alldata['settings'] = $settings;

// 2️⃣ Fetch categories
$categories = getAllData($table_categories, null, null, false);
$alldata['categories'] = $categories;

// 3️⃣ Fetch top-selling items with full details
$stmt = $con->prepare("
    SELECT i.*, mts.countitems,
        (i.items_price - (i.items_price * i.items_discount / 100)) AS itempricediscount
    FROM $table_items i
    INNER JOIN $table_most_selling mts ON i.items_id = mts.items_id
    ORDER BY mts.countitems DESC
");
$stmt->execute();
$items = $stmt->fetchAll(PDO::FETCH_ASSOC);

$alldata['items'] = $items;

// 4️⃣ Return JSON
echo json_encode($alldata);
