<?php
include "./connect.php";

// Get the user ID safely
$userid = filterRequest("id");

// 1️⃣ Fetch notifications for this user
$stmt = $con->prepare("
    SELECT 
        notification_title,
        notification_body,
        notification_title_ar,
        notification_body_ar,
        notification_datetime,
        is_read
    FROM user_notifications
    WHERE notification_userid = ?
    ORDER BY notification_datetime DESC
");
$stmt->execute([$userid]);
$notifications = $stmt->fetchAll(PDO::FETCH_ASSOC);

// 2️⃣ Mark all fetched notifications as read
$updateStmt = $con->prepare("
    UPDATE user_notifications
    SET is_read = 1
    WHERE notification_userid = ? AND is_read = 0
");
$updateStmt->execute([$userid]);

// 3️⃣ Return JSON in expected format
echo json_encode([
    'status' => 'success',
    'data' => $notifications
]);
?>
