<?php
// orders_functions.php
// Only for order-related operations; avoids duplicating functions from functions.php

include_once __DIR__ . "/connect.php";
include_once __DIR__ . "/functions.php"; // Only include common helpers if needed

/**
 * Sanitize POST input to avoid conflicts with filterRequest()
 */
function orderFilterRequest($key)
{
    return isset($_POST[$key]) ? htmlspecialchars(strip_tags($_POST[$key])) : null;
}

/**
 * Update order status safely
 */
function updateOrderStatus($orderId, $status, $adminId, $adminName) {
    global $con;

    $sql = "UPDATE orders
            SET orders_status = :status,
                updated_by_id = :adminId,
                updated_by_name = :adminName
            WHERE orders_id = :orderId";

    $stmt = $con->prepare($sql);
    $stmt->execute([
        ':status' => $status,
        ':adminId' => $adminId,
        ':adminName' => $adminName,
        ':orderId' => $orderId
    ]);

    return $stmt->rowCount(); // returns 1 if updated, 0 if nothing changed
}

/**
 * Log admin action
 */
function logOrderAction($actorId, $actorType, $actorName, $actionType, $orderId, $oldStatus, $newStatus)
{
    global $con;
    $actorType = $actorType ?: 'admin';

    $sql = "INSERT INTO user_logs 
            (actor_id, actor_type, actor_name, action_type, reference_table, reference_id, old_status, new_status, created_at)
            VALUES (:actorId, :actorType, :actorName, :actionType, 'orders', :orderId, :oldStatus, :newStatus, NOW())";
    $stmt = $con->prepare($sql);
    $stmt->execute([
        ':actorId'   => $actorId,
        ':actorType' => $actorType,
        ':actorName' => $actorName,
        ':actionType'=> $actionType,
        ':orderId'   => $orderId,
        ':oldStatus' => $oldStatus,
        ':newStatus' => $newStatus
    ]);
    return $stmt->rowCount();
}

/**
 * Notify user using insertNotify from functions.php
 */
function notifyUser($userId, $titleEn, $bodyEn, $bodyAr, $titleAr, $topic, $screen, $action, $language)
{
    return insertNotify(
        $titleEn,
        $bodyEn,
        $bodyAr,
        $titleAr,
        $userId,
        $topic,
        $screen,
        $action,
        $language
    );
}
?>
