<?php
// websocket_test.php
set_time_limit(0);
ob_implicit_flush();

// Simple WebSocket server test
$socket = socket_create(AF_INET, SOCK_STREAM, SOL_TCP);
socket_set_option($socket, SOL_SOCKET, SO_REUSEADDR, 1);

if (@socket_bind($socket, 'localhost', 8080) === false) {
    echo "❌ WebSocket not supported: Cannot bind to port 8080";
    exit;
}

if (@socket_listen($socket, 10) === false) {
    echo "❌ WebSocket not supported: Cannot listen on port";
    exit;
}

echo "✅ WebSocket might be supported - but check hosting policies";
socket_close($socket);
?>